<?php

class EWRporta_ControllerPublic_Wiki extends XenForo_ControllerPublic_Abstract
{
	public $perms;
	public $slugs;

	public function actionIndex()
	{
		$this->perms = $this->getModelFromCache('EWRporta_Model_Perms')->getPermissions();
		if (!$this->perms['view']) { return $this->responseNoPermission(); }

		if ($this->slugs[0] == "special")
		{
			switch ($this->slugs[1])
			{
				case "pages":			return $this->responseReroute(__CLASS__, 'Pages'); break;
				case "create-page":		return $this->responseReroute(__CLASS__, 'PageCreate'); break;
				case "insert-page":		return $this->responseReroute(__CLASS__, 'PageUpdate'); break;
				case "templates":		return $this->responseReroute(__CLASS__, 'Templates'); break;
				case "template":		return $this->responseReroute(__CLASS__, 'TemplateEdit'); break;
				case "create-template":	return $this->responseReroute(__CLASS__, 'TemplateCreate'); break;
				case "update-template":	return $this->responseReroute(__CLASS__, 'TemplateUpdate'); break;
				case "insert-template":	return $this->responseReroute(__CLASS__, 'TemplateUpdate'); break;
				case "recent":			return $this->responseReroute(__CLASS__, 'Recent'); break;
				case "search":			return $this->responseReroute(__CLASS__, 'Search'); break;
				case "empty-cache":		return $this->responseReroute(__CLASS__, 'CacheEmpty'); break;
				case "empty-history":	return $this->responseReroute(__CLASS__, 'HistoryEmpty'); break;
			}
		}

		if (isset($this->slugs[1]))
		{
			switch ($this->slugs[1])
			{
				case "edit":		return $this->responseReroute(__CLASS__, 'PageEdit'); break;
				case "update":		return $this->responseReroute(__CLASS__, 'PageUpdate'); break;
				case "history":		return $this->responseReroute(__CLASS__, 'PageHistory'); break;
				case "archive":		return $this->responseReroute(__CLASS__, 'PageArchive'); break;
				case "compare":		return $this->responseReroute(__CLASS__, 'PageCompare'); break;
			}
		}

		return $this->responseReroute(__CLASS__, 'PageView');
	}

	public function actionPages()
	{
		$viewParams = array(
			'fullList' => $this->getModelFromCache('EWRporta_Model_Lists')->getPageList(),
		);

		return $this->responseView('EWRporta_ViewPublic_Pages', 'EWRporta_Pages', $viewParams);
	}

	public function actionPageView()
	{
		if ($this->slugs[0] == "") { $this->slugs[0] = "index"; }

		if (!$page = $this->getModelFromCache('EWRporta_Model_Pages')->getPageBySlug($this->slugs[0]))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		$viewParams = array(
			'perms' => $this->perms,
			'page' => $this->getModelFromCache('EWRporta_Model_Pages')->renderPage($page),
			'related' => $this->getModelFromCache('EWRporta_Model_Lists')->getRelated($page),
			'subList' => $this->getModelFromCache('EWRporta_Model_Lists')->getPageList($page['page_id']),
			'breadCrumbs' => array_reverse($this->getModelFromCache('EWRporta_Model_Lists')->getCrumbs($page)),
		);

		return $this->responseView('EWRporta_ViewPublic_PageView', 'EWRporta_PageView', $viewParams);
	}

	public function actionPageCreate()
	{
		if (!$this->perms['create']) { return $this->responseNoPermission(); }

		$viewParams = array(
			'fullList' => $this->getModelFromCache('EWRporta_Model_Lists')->getPageList(),
		);

		return $this->responseView('EWRporta_ViewPublic_PageCreate', 'EWRporta_PageCreate', $viewParams);
	}

	public function actionPageEdit()
	{
		if (!$this->perms['edit']) { return $this->responseNoPermission(); }

		if (!$page = $this->getModelFromCache('EWRporta_Model_Pages')->getPageBySlug($this->slugs[0]))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		switch ($page['page_type'])
		{
			case "html":	$page['selected']['html'] = 'selected="selected"'; break;
			case "phpfile":	$page['selected']['phpfile'] = 'selected="selected"'; break;
			default:		$page['selected']['bbcode'] = 'selected="selected"'; break;
		}

		$viewParams = array(
			'perms' => $this->perms,
			'page' => $page,
			'fullList' => $this->getModelFromCache('EWRporta_Model_Lists')->getPageList(),
			'breadCrumbs' => array_reverse($this->getModelFromCache('EWRporta_Model_Lists')->getCrumbs($page)),
		);

		return $this->responseView('EWRporta_ViewPublic_PageEdit', 'EWRporta_PageEdit', $viewParams);
	}

	public function actionPageUpdate()
	{
		if (!($this->perms['edit'] || $this->perms['create'] || $this->perms['delete']))
		{
			return $this->responseNoPermission();
		}

		$input = $this->_input->filter(array(
			'page_id' => XenForo_Input::UINT,
			'page_name' => XenForo_Input::STRING,
			'page_slug' => XenForo_Input::STRING,
			'page_type' => XenForo_Input::STRING,
			'page_parent' => XenForo_Input::UINT,
			'submit' => XenForo_Input::STRING,
			'delete' => XenForo_Input::STRING,
		));
		$input['page_content'] = $this->getHelper('Editor')->getMessageText('page_content', $this->_input);

		if ($input['delete'])
		{
			$this->getModelFromCache('EWRporta_Model_Pages')->deletePage($input);
		}
		else if ($input['submit'])
		{
			$page = $this->getModelFromCache('EWRporta_Model_Pages')->updatePage($input);
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki', $page));
		}

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
	}

	public function actionPageHistory()
	{
		if (!$page = $this->getModelFromCache('EWRporta_Model_Pages')->getPageBySlug($this->slugs[0]))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		$options = XenForo_Application::get('options');
		$start = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$stop = $options->EWRporta_perpage;
		if ($start < 1) { $start = "1"; }

		$viewParams = array(
			'perms' => $this->perms,
			'page' => $page,
			'start' => $start,
			'stop' => $stop,
			'count' => $this->getModelFromCache('EWRporta_Model_History')->getCount($page),
			'fullList' => $this->getModelFromCache('EWRporta_Model_History')->getHistory($page, $start, $stop),
			'related' => $this->getModelFromCache('EWRporta_Model_Lists')->getRelated($page),
			'breadCrumbs' => array_reverse($this->getModelFromCache('EWRporta_Model_Lists')->getCrumbs($page)),
		);

		return $this->responseView('EWRporta_ViewPublic_PageHistory', 'EWRporta_PageHistory', $viewParams);
	}

	public function actionPageArchive()
	{
		if (!$history = $this->getModelFromCache('EWRporta_Model_History')->getHistoryByID($this->slugs[2]))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		if (!$page = $this->getModelFromCache('EWRporta_Model_Pages')->getPageByID($history['page_id']))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		$viewParams = array(
			'perms' => $this->perms,
			'page' => $page,
			'history' => $history,
			'related' => $this->getModelFromCache('EWRporta_Model_Lists')->getRelated($page),
			'subList' => $this->getModelFromCache('EWRporta_Model_Lists')->getPageList($page['page_id']),
			'breadCrumbs' => array_reverse($this->getModelFromCache('EWRporta_Model_Lists')->getCrumbs($page)),
		);

		return $this->responseView('EWRporta_ViewPublic_PageArchive', 'EWRporta_PageArchive', $viewParams);
	}

	public function actionPageCompare()
	{
		if (!$history = $this->getModelFromCache('EWRporta_Model_History')->getHistoryByID($this->slugs[2]))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		if (!$page = $this->getModelFromCache('EWRporta_Model_Pages')->getPageByID($history['page_id']))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		$diff = new Diff_Compare(explode("\n", $history['history_content']), explode("\n", $page['page_content']));
		$renderer = new Diff_Renderer_Html_SideBySide;

		$viewParams = array(
			'perms' => $this->perms,
			'page' => $page,
			'history' => $history,
			'compare' => $diff->Render($renderer),
			'breadCrumbs' => array_reverse($this->getModelFromCache('EWRporta_Model_Lists')->getCrumbs($page)),
		);

		return $this->responseView('EWRporta_ViewPublic_PageCompare', 'EWRporta_PageCompare', $viewParams);
	}

	public function actionTemplates()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$viewParams = array(
			'fullList' => $this->getModelFromCache('EWRporta_Model_Lists')->getTemplates(),
		);

		return $this->responseView('EWRporta_ViewPublic_Templates', 'EWRporta_Templates', $viewParams);
	}

	public function actionTemplateCreate()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		return $this->responseView('EWRporta_ViewPublic_TemplateCreate', 'EWRporta_TemplateCreate');
	}

	public function actionTemplateEdit()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		if (!$template = $this->getModelFromCache('EWRporta_Model_Templates')->getTemplateBySlug($this->slugs[2]))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		$viewParams = array(
			'perms' => $this->perms,
			'template' => $template,
		);

		return $this->responseView('EWRporta_ViewPublic_TemplateEdit', 'EWRporta_TemplateEdit', $viewParams);
	}

	public function actionTemplateUpdate()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$input = $this->_input->filter(array(
			'template_name' => XenForo_Input::STRING,
			'template_newname' => XenForo_Input::STRING,
			'template_content' => XenForo_Input::STRING,
			'submit' => XenForo_Input::STRING,
			'delete' => XenForo_Input::STRING,
		));

		if ($input['delete'])
		{
			$this->getModelFromCache('EWRporta_Model_Templates')->deleteTemplate($input);
		}
		else if ($input['submit'])
		{
			$this->getModelFromCache('EWRporta_Model_Templates')->updateTemplate($input);
		}

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 'wiki/special/templates/');
	}

	public function actionRecent()
	{
		$options = XenForo_Application::get('options');
		$start = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$stop = $options->EWRporta_perpage;
		if ($start < 1) { $start = "1"; }

		$viewParams = array(
			'perms' => $this->perms,
			'start' => $start,
			'stop' => $stop,
			'count' => $this->getModelFromCache('EWRporta_Model_History')->getRecentCount(),
			'fullList' => $this->getModelFromCache('EWRporta_Model_History')->getRecentHistory($start, $stop),
		);

		return $this->responseView('EWRporta_ViewPublic_Recent', 'EWRporta_Recent', $viewParams);
	}

	public function actionSearch()
	{
		if (!$keywords = $this->_input->filterSingle('keywords', XenForo_Input::STRING))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('full:wiki'));
		}

		$viewParams = array(
			'keywords' => $keywords,
			'results' => $this->getModelFromCache('EWRporta_Model_Search')->getSearchResults($keywords),
		);

		return $this->responseView('EWRporta_ViewPublic_Search', 'EWRporta_Search', $viewParams);
	}

	public function actionCacheEmpty()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$this->getModelFromCache('EWRporta_Model_Cache')->emptyCache();

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 'wiki/special/templates/');
	}

	public function actionHistoryEmpty()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$this->getModelFromCache('EWRporta_Model_Cache')->emptyHistory();

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 'wiki/special/recent/');
	}

	public function __construct($request, $response, $routeMatch)
	{
		parent::__construct($request, $response, $routeMatch);

		$this->perms = $this->getModelFromCache('EWRporta_Model_Perms')->getPermissions();
		$this->slugs = explode('/', $this->_routeMatch->getMinorSection());
	}
}